import { auth } from "@/auth";
import { Badge } from "@/components/ui/badge";
import { getOwnerProducts, isUserPremium } from "@/lib/server-actions";
import Image from "next/image";
import Link from "next/link";
import { redirect } from "next/navigation";
import { PiCrown, PiPlus } from "react-icons/pi";

const MyProducts = async () => {

  const authenticatedUser = await auth();

  if (!authenticatedUser) {
    redirect("/");
  }
  




  const products = await getOwnerProducts();

  const isPremium = await isUserPremium();

  return (
    <div className="mx-auto lg:w-3/5 py-10 px-6">
      {products.length === 0 ? (
        <div>
          <h1 className="text-3xl font-bold">No products found </h1>
          <p className="text-gray-500">
            Looks like you have not created any products yet, click the button
            below to get started
          </p>

          <Link href={"/new-product"}>
            <div
              className="bg-[#071952] text-white p-4 
            rounded-md mt-4 w-60 h-56 flex items-center justify-center flex-col"
            >
              <PiPlus className="text-3xl mb-4" />
              <p className="text-lg">Create a product</p>
            </div>
          </Link>
        </div>
      ) : (
        <div>
          <h1 className="text-3xl font-bold">Your Products</h1>
          <p>Manage your products here</p>

          {isPremium ? (
            <div className="flex gap-x-4 items-center mt-10">
              <PiCrown className="text-2xl text-[#071952]" />
              <p className="text-lg">You are a premium user</p>
            </div>
          ) : (
            <>
              <p className="pt-6">({products.length} / 2) free products </p>
            </>
          )}

          <div className="grid grid-cols-2 md:grid-cols-3 h-full gap-5 mt-10">
            {products.map((product) => (
              <Link href={`/edit/${product.id}`} key={product.id}>
              <div
                className="
                  rounded-lg 
                  hover:scale-105
                  transition-transform
                  duration-300
                  transform
                  ease-in-out
                  flex
                  flex-col
                  border
      
                "
              >
                <Image
                  src={product.logo}
                  alt="logo"
                  width={1000}
                  height={1000}
                  className="object-cover rounded-lg p-3 w-full h-36 md:h-48"
                />
                <div className=" w-full mt-2 p-4 border-t inline-flex justify-center flex-col items-start" >
                  <h2 className="text-lg font-bold py-2 text-center">{product.name}</h2>
                  <p className="">{product.description.length > 20
                   ? `${product.description.substring(0, 20)}...`
                   : product.description}</p>
                  {product.status === "PENDING" && (
                    <Badge className="bg-orange-400 mt-2">Pending</Badge>
                  )}
                  {product.status === "ACTIVE" && (
                    <Badge className="bg-green-400 mt-2">ACTIVE</Badge>
                  )}
                  {product.status === "REJECTED" && (
                    <Badge className="bg-red-400 mt-2">REJECTED</Badge>
                  )}
                </div>
              </div>
            </Link>
            ))}
          </div>
        </div>
      )}
    </div>
  );
};

export default MyProducts;
