import { auth } from "@/auth";
import ProductItem from "./product-item";
import { useState } from "react";
import Link from "next/link";


interface ActiveProductsProps {
  activeProducts: any;
}

const ActiveProducts: React.FC<ActiveProductsProps> = async ({
  activeProducts,
}) => {
  const authenticatedUser = await auth();
  
  const formattedActiveProducts = activeProducts?.map((product: any) => {
    const {
      id,
      name,
      slug,
      headline,
      description,
      logo,
      releaseDate,
      website,
      twitter,
      discord,
      createdAt,
      updatedAt,
      userId,
      status,
      images,
      categories,
      comments,
      upvotes
    } = product;



    const imageUrls = images.map((image: any) => image.url);
    const categoryNames = categories.map((category: any) => category.name);
    const commentsCount = comments ? comments.length : 0;

    const commentText = comments ? comments.map((comment: any) => ({
        id: comment.id,
        profile: comment.profilePicture,
        body : comment.body,
        user : comment.user.name,
        timestamp : comment.createdAt,
        userId : comment.user.id,
        name: comment.user.name.toLowerCase().replace(/\s/g, '_'),

    })) : [];


    const upvotesCount = upvotes ? upvotes.length : 0;
    const upvotesData = upvotes.map((upvote: any) => upvote.user.id)

    return {
      id,
      name,
      slug,
      headline,
      description,
      logo,
      releaseDate,
      website,
      twitter,
      discord,
      createdAt,
      updatedAt,
      userId,
      status,
      images: imageUrls,
      categories: categoryNames,
      commentsLength: commentsCount,
      commentData : commentText,
      upvoters: upvotesData,
      upvotes: upvotesCount,
    };
  });

  console.log(formattedActiveProducts.length);

  return (
    <div className="w-full">
      <div className="flex items-center border-b pb-3 justify-between">
        <div  className="flex first:justify-between items-center" >
            <h1 className="text-xl font-medium">Products</h1>
           <Link href={"/categories"} className="text-xs font-medium mt-1 text-[#868686] cursor-pointer hover:text-[#071952] ml-4">
            {"categories ->"}
           </Link>
        </div>
        <div className="flex first:justify-between items-center" >
          <p className="text-sm font-medium mt-1 text-[#071952] cursor-pointer hover:text-[#071952]" >All</p>
        </div>
      </div>

      <div className="space-y-2 py-6 flex flex-col">
        {
        formattedActiveProducts.map((product: any) => (
          <ProductItem
            key={product.id}
            product={product}
            authenticatedUser={authenticatedUser}
          />
        ))
        }

        {
         formattedActiveProducts.length == 0 && 
         <p>There is no product yet. Be first who add product</p>
        }
      </div>
    </div>
  );
};

export default ActiveProducts;
